//-----------------------------------------------------------------------------
//  Copyright (C) 2002-2025 Thomas S. Ullrich
//
//  This file is part of "xyscan".
//
//  This file may be used under the terms of the GNU General Public License.
//  This project is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License.
//  
//  Author: Thomas S. Ullrich
//  Last update: Oct 31, 2025
//-----------------------------------------------------------------------------
#pragma once
#include <QVersionNumber>
#include <QString>

//
// Current version(only place where defined)
// Extract via:
//     xyscan --numeric-version
//
static constexpr int XYSCAN_VERSION_MAJOR = 4;
static constexpr int XYSCAN_VERSION_MINOR = 7;
static constexpr int XYSCAN_VERSION_PATCH = 0;

//
// Canonical version object/string
//
static inline QVersionNumber xyscanVersion() {
    return QVersionNumber(XYSCAN_VERSION_MAJOR, XYSCAN_VERSION_MINOR, XYSCAN_VERSION_PATCH);
}
static inline QString xyscanVersionString() {
    return xyscanVersion().toString();   // e.g. "4.6.8"
}
